<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductAttributeValue extends Model 
{

    protected $table = 'products_attributes_values';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product_attribute()
    {
        return $this->belongsTo('App\Models\Product\ProductAttribute', 'product_attribute_id');
    }

    public function products_allowed_attributes_values()
    {
        return $this->hasMany('App\Models\Product\ProductAllowedAttributeValue', 'product_attribute_value_id');
    }

    public function products_actual_attributes_values()
    {
        return $this->hasMany('App\Models\Product\ProductActualAttributeValue', 'product_attribute_value_id');
    }

}